﻿/*
 * Parameter Passing
 * How does pass-by-value and pass-by-ref effect value and reference types
 * John Sterling
 */

using System;
//using System.Collections.Generic;
//using System.Linq;
//using System.Text;
//using System.Threading.Tasks;

namespace Parameter_Passing
{
    struct ThingStruct { public int value; }
    class ThingClass { public int value = 0; }

    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Creating default ThingStruct thingOne");
            ThingStruct thingOne = new ThingStruct();
            Console.WriteLine("thingOne.value: " + thingOne.value);
            Console.WriteLine("Passing thingOne by value");
            modStruct(thingOne);  // Passing a value type by value
            Console.WriteLine("thingOne.value: " + thingOne.value);  // Unchanged
            Console.WriteLine("Passing thingOne by reference");
            // Note the function definition and the call have to say it is by reference
            modStructRef(ref thingOne);  // Passing a value type by reference
            Console.WriteLine("thingOne.value: " + thingOne.value);  // Changed
            Console.WriteLine("=================");

            ThingClass thingTwo = new ThingClass();
            Console.WriteLine(thingTwo.value);
            modClass(thingTwo);  // Passing a reference type by value
            // Value changed but thingTwo not set to null
            Console.WriteLine(thingTwo.value);  
            modClassRef(ref thingTwo);
            Console.WriteLine(thingTwo.value); // thingTwo is null.  Crash!
        }

        // Passing a struct by value
        static void modStruct(ThingStruct thing)
        {
            Console.WriteLine("Modifying value parameter ThingStruct's value to 17");
            thing.value = 17;
            // thing = null;  // Compilation error.  Only reference types can by null.
        }
        // Passing a struct by reference
        static void modStructRef(ref ThingStruct thing)
        {
            thing.value = 42;
            // thing = null;  // Compilation error.  Only reference types can by null.
        }

        // Passing a class by value
        // Note that it is the reference that was copied, 
        // not the thing and that setting thing to null does not effect the caller.
        static void modClass(ThingClass thing)
        {
            thing.value = 17;
            thing = null;
        }

        // Passing a class by reference
        // Note that setting thing to null does effect the caller.
        static void modClassRef(ref ThingClass thing)
        {
            thing.value = 42;
            thing = null;
        }
    }
}
